using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

using gov.va.med.vbecs.ExceptionManagement;

namespace gov.va.med.vbecs.DAL
{

		#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Mike      </Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>11/27/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data access layer component providing database 
	///	read/write functionality for lab tests data
	///	</summary>

		#endregion

	public class LabTest
	{

		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/27/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="992"> 
		///		<ExpectedInput>Report type code and division code</ExpectedInput>
		///		<ExpectedOutput>Data table containing lab tests</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="996"> 
		///		<ExpectedInput>Invalid ReportTypeId</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>
		/// Retrieves lab test parameters of a specific report type within a given division.
		///</summary>
		///<param name="reportTypeId">Report type ID</param>
		///<returns>DataTable containing lab rest parameters</returns>
		public static DataTable GetLabTests(int reportTypeId)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetLabTests.reporttypeid, System.Data.SqlDbType.Int),
				new SqlParameter(STOREDPROC.GetLabTests.divisioncode, System.Data.SqlDbType.Char)
			};

			prms[0].Value = reportTypeId;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;

			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetLabTests.StoredProcName, prms);

			ds.Tables[0].Columns[gov.va.med.vbecs.Common.VbecsTables.ReportType.ReportTypeId].AutoIncrement = false;
			ds.Tables[0].Columns[gov.va.med.vbecs.Common.VbecsTables.ReportType.ReportTypeId].AllowDBNull = true;
			ds.Tables[0].AcceptChanges();
			
			return ds.Tables[0];

		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/20/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1184"> 
		///		<ExpectedInput>componentClassID, labTestId</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1185"> 
		///		<ExpectedInput>Invalid ComponentClassID</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetSpecimenTestThresholds
		/// </summary>
		/// <param name="componentClassID">componentClassID</param>
		/// <param name="labTestID">labTestID</param>
		/// <returns>Data table</returns>
		public static DataTable GetSpecimenTestThresholds(int componentClassID, string labTestID)
		{
			SqlParameter[] prms =
			{
				
				new SqlParameter(STOREDPROC.GetSpecimenTestThresholds.componentclassid, System.Data.SqlDbType.Int),
				new SqlParameter(STOREDPROC.GetSpecimenTestThresholds.labtestid, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.GetSpecimenTestThresholds.divisioncode, System.Data.SqlDbType.Char)
			};

			prms[0].Value = componentClassID;
			prms[1].Value = labTestID;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetSpecimenTestThresholds.StoredProcName, prms);

			return ds.Tables[0];

		}

		///<Developers>
		///	<Developer>Mike      </Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/27/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="993"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1902"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		///<summary>
		/// Saves the changes in the DataTable containing the lab tests data
		/// to the database.
		///</summary>
		/// <param name="sprocArrayList">List of stored procedures to use</param>
		/// <param name="dtArrayList">ArrayList of DataTables containing lab tests data</param>
		public static void SaveLabTests( System.Collections.ArrayList sprocArrayList, System.Collections.ArrayList dtArrayList)
		{
			Common.StoredProcedure sproc = new Common.StoredProcedure();

			int returnValue = sproc.TransactionalGetValue(sprocArrayList,dtArrayList);
		}
	}
}
